#
# TWiki WikiClone (see $wikiversion for version)
#
# Configuration and custom extensions for wiki.pm of TWiki.
#
# Copyright (C) 1999, 2000 Peter Thoeny, TakeFive Software Inc., 
# peter.thoeny@takefive.com , peter.thoeny@attglobal.net
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details, published at 
# http://www.gnu.ai.mit.edu/copyleft/gpl.html 
#
# Notes:
# - Latest version at http://your.domain.com/twiki
# - Installation instructions in $dataDir/TWiki/TWikiDocumentation.txt
# - Customize variables in wikicfg.pm when installing TWiki.
#   NOTE: Don't forget to customize also the Main.TWikiPreferences topic.
# - Optionally change wikicfg.pm for custom extensions of rendering rules.
# - Files wikifcg.pm and wikisearch.pm are included by wiki.pm
# - Upgrading TWiki is easy as long as you do not customize wiki.pm.
# - Variables that can be accessed from topics (see details in
#   TWikiDocumentation.html) :
#       %TOPIC%          name of current topic
#       %WEB%            name of current web
#       %WIKIHOMEURL%    link of top left icon
#       %SCRIPTURL%      base TWiki script URL (place of view, edit...)
#       %SCRIPTURLPATH%  like %SCRIPTURL%, but path only (cut protocol and domain)
#       %SCRIPTSUFFIX%   script suffix (empty by default, ".pl" if required)
#       %PUBURL%         public URL (root of attachment URL)
#       %PUBURLPATH%     path of public URL
#       %ATTACHURL%      attachment URL of current topic
#       %ATTACHURLPATH%  path of attachment URL of current topic
#       %DATE%           today's date
#       %WIKIVERSION%    tool version
#       %USERNAME%       login user name
#       %WIKIUSERNAME%   wiki user name
#       %WIKITOOLNAME%   tool name (TWiki)
#       %MAINWEB%        main web name (Main)
#       %TWIKIWEB%       TWiki system web name (TWiki)
#       %HOMETOPIC%      home topic name (WebHome)
#       %NOTIFYTOPIC%    notify topic name (WebNotify)
#       %WIKIUSERSTOPIC% user list topic name (TWikiUsers)
#       %WIKIPREFSTOPIC% site-level preferences topic name (TWikiPreferences)
#       %WEBPREFSTOPIC%  web preferences topic name (WebPreferences)
#       %STATISTICSTOPIC statistics topic name (WebStatistics)
#       %INCLUDE{...}%   server side include
#       %SEARCH{...}%    inline search


# variables that need to be changed when installing on a new server:
# ==================================================================
#                   %WIKIHOMEURL% : link of TWiki icon in upper left corner :
$wikiHomeUrl      = "http://didattica.dma.unifi.it/twiki";
#                   Host of TWiki URL :    (Example "http://myhost.com:123")
$defaultUrlHost   = "http://didattica.dma.unifi.it";
#                   %SCRIPTURLPATH% : cgi-bin path of TWiki URL:
$scriptUrlPath    = "/twiki/bin";
#                   %PUBURLPATH% : Public data path of TWiki URL (root of attachments) :
$pubUrlPath       = "/twiki/pub";
#                   Public data directory, must match $pubUrlPath :
$pubDir           = "/home/httpd/realtwiki/pub";
#                   Template directory :
$templateDir      = "/home/httpd/realtwiki/templates";
#                   Data (topic files) root directory :
$dataDir          = "/home/httpd/realtwiki/data";
#FB cache
#                   %CACHEURLPATH% : Public data path of TWiki cache URL 
#                   (root  of cached documents) :
$cacheUrlPath       = "/twiki/cache";
#                   Public cache directory, must match $cacheUrlPath :
$cacheDir           = "/home/httpd/realtwiki/cache";
#/FB

# variables that might need to be changed:
# ==================================================================
#                   %SCRIPTSUFFIX% : Suffix of TWiki Perl scripts (i.e. ".pl") :
$scriptSuffix     = "";
#                   set ENV{'PATH'} explicitly for taint checks ( #!perl -T option ) :
$envPath          = "/bin:/usr/bin";
#                   mail program :
$mailProgram      = "/usr/sbin/sendmail -t -oi -oeq";
#                   RCS directory (find out by 'which rcs') :
$rcsDir           = "/usr/bin";
#                   RCS check in command :
$revCiCmd         = "$rcsDir/ci -l -q -mnone -t-none -w'%USERNAME%' %FILENAME%";
#                   RCS check in command with date :
$revCiDateCmd     = "$rcsDir/ci -l -q -mnone -t-none -d'%DATE%' -w'%USERNAME%' %FILENAME%";
#                   RCS check out command :
$revCoCmd         = "$rcsDir/co -q -p%REVISION% %FILENAME%";
#                   RCS history command :
$revHistCmd       = "$rcsDir/rlog -h %FILENAME%";
#                   RCS history on revision command :
$revInfoCmd       = "$rcsDir/rlog -r%REVISION% %FILENAME%";
#                   RCS revision diff command :
$revDiffCmd       = "$rcsDir/rcsdiff -q -w -B -r%REVISION1% -r%REVISION2% %FILENAME%";
#                   RCS delete revision command :
$revDelRevCmd     = "$rcsDir/rcs -q -o%REVISION% %FILENAME%";
#                   RCS unlock command :
$revUnlockCmd     = "$rcsDir/rcs -q -u %FILENAME%";
#                   RCS lock command :
$revLockCmd       = "$rcsDir/rcs -q -l %FILENAME%";
#                   Unix ls command :
$lsCmd            = "/bin/ls";
#                   Unix cp command :
$cpCmd            = "/bin/cp";
#                   Unix egrep command :
$egrepCmd         = "/bin/egrep";
#                   Unix fgrep command :
$fgrepCmd         = "/bin/fgrep";

# variables that probably do not change:
# ==================================================================
#                   %WIKITOOLNAME% : TWiki tool name, default "TWiki" :
$wikiToolName       = "TWiki";
#                   Regex security filter for web name, topic name, user name :
$securityFilter     = "[\\\*\?\~\^\$\@\%\`\"\'\&\;\|\<\>\x00-\x1F]";
#                   Default user name, default "guest" :
$defaultUserName    = "guest";
#                   %MAINWEB% : Name of Main web, default "Main" :
$mainWebname        = "Main";
#                   %TWIKIWEB% : Name of TWiki system web, default "TWiki" :
$twikiWebname       = "TWiki";
#                   Pathname of debug file :
$debugFilename      = "$dataDir/debug.txt";
#                   Pathname of user name/password file for authentication :
$htpasswdFilename   = "$dataDir/.htpasswd";
#                   Pathname of log file :
$logFilename        = "$dataDir/log%DATE%.txt";
#                   %WIKIUSERSTOPIC% : Name of users list topic :
$wikiUsersTopicname = "TWikiUsers";
#                   Pathname of users topic, used to translate Intranet name to Wiki name :
$userListFilename   = "$dataDir/$mainWebname/$wikiUsersTopicname.txt";
#                   %HOMETOPIC% : Name of main topic in a web, default "WebHome" :
$mainTopicname      = "WebHome";
#                   %NOTIFYTOPIC% : Name of topic for email notifications, default "WebNotify" :
$notifyTopicname  = "WebNotify";
#                   %WIKIPREFSTOPIC% : Name of site-level preferences topic, default "TWikiPreferences" :
$wikiPrefsTopicname = "TWikiPreferences";
#                   %WEBPREFSTOPIC% : Name of preferences topic in a web, default "WebPreferences" :
$webPrefsTopicname  = "WebPreferences";
#                   %STATISTICSTOPIC% : Name of statistics topic, default "WebStatistics" :
$statisticsTopicname = "WebStatistics";
#                   Number of top viewed topics to show in statistics topic, default "10" :
$statsTopViews      = "10";
#                   Number of top contributors to show in statistics topic, default "10" :
$statsTopContrib    = "10";
#                   Show how many number of revision links, "0" for all, default "4" :
$numberOfRevisions  = "4";
#                   Number of seconds a topic is locked during edit, default "3600" :
$editLockTime       = "3600";

# flag variables that could change:
# ==================================================================
# values are "0" for no, or "1" for yes
#                   Keep same revision if topic is saved again within edit lock time. Default "1"
$doKeepRevIfEditLock = "1";
#                   Remove port number from URL. Default "0"
$doRemovePortNumber = "0";
#                   Change non existing plural topic name to singular,
#                   e.g. TestPolicies to TestPolicy. Default "1"
$doPluralToSingular = "1";
#                   Remove ".." from %INCLUDE{""}% filename, to
#                   prevent includes of "../../file". Default "1"
$doSecureInclude    = "1";
#                   Log topic views to $logFilename. Default "0"
$doLogTopicView     = "0";
#                   Log topic saves to $logFilename. Default "0"
$doLogTopicEdit     = "0";
#                   Log topic saves to $logFilename. Default "1"
$doLogTopicSave     = "1";
#                   Log view attach to $logFilename. Default "0"
$doLogTopicAttach   = "0";
#                   Log file upload to $logFilename. Default "1"
$doLogTopicUpload   = "1";
#                   Log topic rdiffs to $logFilename. Default "0"
$doLogTopicRdiff    = "0";
#                   Log view changes to $logFilename. Default "0"
$doLogTopicChanges  = "0";
#                   Log view changes to $logFilename. Default "0"
$doLogTopicSearch   = "0";
#                   Log user registration to $logFilename. Default "1"
$doLogRegistration  = "1";

# NOTE: Don't forget to customize also the TWiki.TWikiPreferences topic.

#AS
# =========================
sub renderSubWebNames
{
    # 18-08-00 (c) Andrea Sterbini a.sterbini@flashnet.it
    # Sub to format subweb names (web/web1 -> web.web1)
    # with automatic construction of links to the above webs
    # It transforms a dotted or slashed name to a rendered link
    # $theWeb is the string to be transformed
    # if $lastIsTopic is true then the last piece is a topic instead than a web
    
    my( $theWeb, $lastIsTopic ) = @_;
    $theWeb =~ s/\./\//go ;

    my $topic   = $theWeb;
    
    if( $lastIsTopic ) {
        $topic  =~ s/(.*)\/([^\/]*)/$2/go ;
        $theWeb =~ s/(.*)\/([^\/]*)/$1/go ;
    };
    
    my ($item , @list) = split(/\//, $theWeb);
        
    my $webPath = $item;
    my $webName = internalLink("$webPath","$mainTopicname",$item,"",1);
    foreach $item (@list){
        $webPath = $webPath . "/" . $item ; 
        $webName = $webName . "." . internalLink("$webPath","$mainTopicname",$item,"",1) ;
    }
    
    if( $lastIsTopic ) {
        $webName = $webName . "." . internalLink("$webPath","$topic","$topic","",1) ;
    }

    return "$webName";
}
#/AS
#FB
# ======================== LaTeX
sub handleLaTeX
{
    my( $arg ) = @_;
    # to do: check syntax
    open FILE, ">$pubDir/hevea.tex";
    print FILE $arg;
    close FILE;	
    return `/usr/bin/hevea < $pubDir/hevea.tex`;
}         
#/FB
#FB
# ======================== GNUPLOT
#sub handleGnuplot
#{
#    my( $arg ) = @_;
#    # to do: check syntax
#    $arg =~ s/(shell|\!)//g;
#    $arg =~ s/\s/%20/g;
#    $arg =~ s/\+/%2B/g;
#    $arg =~ s/\;/%3B/g;
#
#
#    return "<img src=\"$scriptUrlPath/gnuplot?commands=$arg\">"; 
#}         
#/FB

#FB
# =========================
sub externalNormalLink
{
    my( $pre, $url, $text) = @_;
    if( $url =~ /\.(gif|jpg|jpeg)$/ ) {
        my $filename = $url;
        $filename =~ s@.*/([^/]*)@$1@go;
        return "$pre<IMG src=\"$url\" alt=\"$filename\">";
    }

    return "$pre<A href=\"$url\" target=\"_top\">$text</A>";
}

sub isSubWeb
{
    my( $web, $name ) = @_;
    return -d "$dataDir/$web/$name";
}

#/FB

# =========================
sub extendHandleCommonTags
{
    # This is the place to define customized tags and variables
    # Called by sub handleCommonTags, after %INCLUDE:"..."%

    my( $text, $topic, $theWeb ) = @_;

    # for compatibility for earlier TWiki versions:
    $text=~ s/%INCLUDE:"(.*?)"%/&handleIncludeFile($1)/geo;
    $text=~ s/%INCLUDE:"(.*?)"%/&handleIncludeFile($1)/geo;  # allow two level includes

    # do custom extension rule, like for example:
    # $text=~ s/%WIKIWEB%/$wikiToolName.$theWeb/go;

#AS
    $text=~ s/%WEBNAME%/&renderSubWebNames("$theWeb",0)/geo;
#/AS
#FB LaTeX
    $text =~ s/%LATEX{(.*?)}%/&handleLaTeX($1)/ges;
    $text =~ s/%LATEX%/&handleLaTeX('\LaTeX')/geo; # logo      
#/FB
#FB gnuplot
    $text =~ s/%GNUPLOT{(.*?)}%/&handleGnuplot($theWeb,$topic,$1)/ges;
#/FB
#FB extend wiki notation, see  http://TWiki.SourceForge.net/cgi-bin/view/Codev/FlexibleWikiWords
# links can be: 
#[[this is a link]] -> <a href=this_is_a_link>this is a link</a>
#[[this is a link|http://link]] -> <a href=http://link>this is a link</a>
#[[this is a link||rellink]] -> <a href=rellink>this is a link</a>
# in the latter case one has to distinguish between internal and external links
    $text=~s/([\*\s][\(\-\*\s]*)\[\[([a-zA-Z\s]*)\|((http|ftp|gopher|news|https)\:(\S+[^\s\.,!\?;:]))\]\]/&externalNormalLink($1,$3,$2)/geo; 
    $text=~s/([\*\s][\(\-\*\s]*)\[\[([a-zA-Z\s]*)\|\|(\S+[^\s\.,!\?;:])\]\]/&externalNormalLink($1,$3,$2)/geo; 
    $text =~ s/([\*\s][\(\-\*\s]*)\[\[([a-zA-Z\s]*)\|([a-zA-Z\s]*)\]\]/&internalLink($webName,$3,$2,$1,1)/geo; 
    $text =~ s/([\*\s][\(\-\*\s]*)\[\[([a-zA-Z_\s]*)\]\]/&internalLink($webName,$2,$2,$1,1)/geo; 
#/FB
    return $text;
}


# =========================
sub extendGetRenderedVersionOutsidePRE
{
    # This is the place to define customized rendering rules
    # Called by sub getRenderedVersion, in loop outside of <PRE> tag

    my( $text, $theWeb ) = @_;

    # do custom extension rule, like for example:
    # s/old/new/go;

    # render *_text_* as "bold italic" text:
    s/(^|\s)\*_([^\s].*?[^\s])_\*(\s|$)/$1<STRONG><EM>$2<\/EM><\/STRONG>$3/go;

#AS
    # render a dotted topic name as a link (with links to the above webs)
   s/(^|\s)([A-Z][a-zA-Z0-9]*((\.|\/)[A-Z][a-zA-Z0-9]*)*((\.|\/)[A-Z][a-zA-Z0-9]*[A-Z][a-zA-Z0-9]*))(\s|$)/$1.&renderSubWebNames("$2",1)/geo;
#AS
 

    # Use alternate %Web:WikiName% syntax (versus the standard Web.WikiName).
    # This is an old JosWiki render option. (Uncomment for JosWiki compatibility)
#    s/(^|\s|\()\%([^\s].*?[^\s]):([^\s].*?[^\s])\%/&internalLink($2,$3,"$2:$3",$1,1)/geo;

    # Use "forced" non-WikiName links (i.e. %Linkname%)
    # This is an old JosWiki render option. (Uncomment for JosWiki compatibility)
#    s/(^|\s|\()\%([^\s].*?[^\s])\%/&internalLink($theWeb,$2,$2,$1,1)/geo;

    # Use "forced" non-WikiName links (i.e. %Web.Linkname%)
    # This is an old JosWiki render option combined with the new Web.LinkName notation
    # (Uncomment for JosWiki compatibility)
#    s/(^|\s|\()\%([a-zA-Z0-9]+)\.(.*?[^\s])\%(\s|\)|$)/&internalLink($2,$3,$3,$1,1)/geo;

#FB multi-language
		my $defaultLanguage = getPrefsValue("DEFAULTLANGUAGE"); 
		my $language = getPrefsValue("LANGUAGE"); # it should be it, es, etc. 		
		$language = $defaultLanguage unless $language;
		$language = "en" unless $language;
		$language = lc($language);
		if ($language eq "it") {

			# accented letters in italian
			# avoid accents with \'
			# first replace common apotrophes
					s/(\s)po\'/$1po\\\'/go;
			#now regular accents		
					s/a\'/&agrave;/go;
					s/i\'/&igrave;/go;
					s/o\'/&ograve;/go;
					s/u\'/&ugrave;/go;
					s/he\'/h&eacute;/go;
					s/e\'/&egrave;/go;

					s/A\'/&Agrave;/go;
					s/I\'/&Igrave;/go;
					s/O\'/&Ograve;/go;
					s/U\'/&Ugrave;/go;
					s/HE\'/H&Eacute;/go;
					s/E\'/&Egrave;/go;
			#and finally the escaped apostrophes
					s/\\\'/\'/go;
		}

#/FB		

    return $_;
}


# =========================
sub extendGetRenderedVersionInsidePRE
{
    # This is the place to define customized rendering rules
    # Called by sub getRenderedVersion, in loop inside of <PRE> tag

    my( $text, $theWeb ) = @_;

    # do custom extension rule, like for example:
    # s/old/new/go;

    return $_;
}

