package TWiki::Plugins::SortedHeadPlugin;

use strict;

use TWiki;

require TWiki::Func;    # The plugins API
require TWiki::Plugins; # For the API version

our $VERSION = '-1';
our $RELEASE = 'TWiki-4.2';
our $SHORTDESCRIPTION = 'Support for sorting of HEAD tags';
our $NO_PREFS_IN_TOPIC = 1;

sub initPlugin {
    my( $topic, $web, $user, $installWeb ) = @_;

    # Monkey-patch TWiki::addToHEAD and TWiki::Func::addToHEAD
    return 0 unless( defined &TWiki::addToHEAD);
    undef &TWiki::addToHEAD;
    *TWiki::addToHEAD = \&TWiki::Plugins::SortedHeadPlugin::addToHEAD;
    undef &TWiki::Func::addToHEAD;
    *TWiki::Func::addToHEAD = sub {
        $TWiki::Plugins::SESSION->addToHEAD(@_);
    };

    TWiki::Func::registerTagHandler('ADDTOHEAD', \&_ADDTOHEAD);
    TWiki::Func::registerTagHandler('RENDERHEAD', \&_RENDERHEAD);

    return 1;
}

sub _ADDTOHEAD {
    my ($session, $args, $topic, $web) = @_;

    my $_DEFAULT = $args->{_DEFAULT};
    my $text = $args->{text};
    $topic = $args->{topic};
    my $requires = $args->{requires};
    if (defined $topic) {
        ($web, $topic) = TWiki::Func::normalizeWebTopicName($web, $topic);
        my $dummy;
        ($dummy, $text) = TWiki::Func::readTopic($web, $topic);
    }
    $text = $_DEFAULT unless defined $text;
    $text = '' unless defined $text;

    $session->addToHEAD($_DEFAULT, $text, $requires);
    return '';
}

sub addToHEAD {
	my( $this, $tag, $header, $requires ) = @_;

    # Expand TWiki variables in the header
	$header = $this->handleCommonTags( $header, $this->{webName},
                                       $this->{topicName} );
	
    $this->{_SORTEDHEADS} ||= {};
    $tag ||= '';

    $requires ||= '';
    my $debug = '';

    # Resolve to references to build DAG
    my @requires;
    foreach my $req (split(/,\s*/, $requires)) {
        unless ($this->{_SORTEDHEADS}->{$req}) {
            $this->{_SORTEDHEADS}->{$req} = {
                tag => $req,
                requires => [],
                header => '',
            };
        }
        push(@requires, $this->{_SORTEDHEADS}->{$req});
    }
    my $record = $this->{_SORTEDHEADS}->{$tag};
    unless ($record) {
        $record = { tag => $tag };
        $this->{_SORTEDHEADS}->{$tag} = $record;
    }
    $record->{requires} = \@requires;
    $record->{header} = $header;

    # Temporary, for compatibility until %RENDERHEAD% is embedded
    # in the skins
    $this->{_HTMLHEADERS}{GENERATED_HEADERS} = _genHeaders($this);
}

sub _visit {
    my ($v, $visited, $list) = @_;
    return if $visited->{$v};
    foreach my $r (@{$v->{requires}}) {
        _visit($r, $visited, $list);
    }
    push(@$list, $v);
    $visited->{$v} = 1;
}

sub _genHeaders {
    my ($this) = @_;
    return '' unless $this->{_SORTEDHEADS};

    # Loop through the vertices of the graph, in any order, initiating
    # a depth-first search for any vertex that has not already been
    # visited by a previous search. The desired topological sorting is
    # the reverse postorder of these searches. That is, we can construct
    # the ordering as a list of vertices, by adding each vertex to the
    # start of the list at the time when the depth-first search is
    # processing that vertex and has returned from processing all children
    # of that vertex. Since each edge and vertex is visited once, the
    # algorithm runs in linear time.
    my %visited;
    my @total;
    foreach my $v (values %{$this->{_SORTEDHEADS}}) {
        _visit($v, \%visited, \@total);
    }

    return $debug.join(
        "\n",
        map { "<!-- $_->{tag} --> $_->{header}" } @total);
}

sub _RENDERHEAD {
    my $this = shift;
    return _genHeaders($this);
}

1;
