package WWW::Mechanize::TWiki;

use strict;
use warnings FATAL => 'all';
our $VERSION = '0.01';

use base qw( WWW::Mechanize );

sub new {
    my $class = shift;
    my %args = @_;
    my $self = $class->SUPER::new( %args );
    return $self;
}

use Data::Dumper qw( Dumper );
sub go {
    my $self = shift;
    my %args = @_;
    return $args{url};
}

__END__

=head1 NAME

WWW::Mechanize::TWiki - drive TWiki wikis

=head1 SYNOPSIS

  use WWW::Mechanize::TWiki;
  my $ua = WWW::Mechanize::TWiki->new();
  $ua->get($url);
  ???

=head1 DESCRIPTION

This module is a subclass of L<WWW::Mechanize> that ...

=head1 CONSTRUCTOR

=head2 new

The constructor is provided by L<WWW::Mechnize>. See that module's
documentation for details.

=head1 METHODS

The vast majority of methods are provided by L<WWW::Mechanize>. See
that module's documentation for details. Additional methods provided
by this module follow. The most useful method is
client_response_receive_time, or how long it took to get the data from
the webserver once the response was made (and gives an idea of how
loaded the webserver was). All times are in seconds.

=head1 THANKS

Andy Lester for L<WWW::Mechanize>. Leon Brocard for L<WWW::Mechanize::Timed>

=head1 LICENCE AND COPYRIGHT

This module is copyright William B. Norris IV 2004. All rights reserved.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.000 or,
at your option, any later version of Perl 5 you may have available.

The full text of the licences can be found in the F<Artistic> and
F<COPYING> files included with this module, or in L<perlartistic> and
L<perlgpl> as supplied with Perl 5.8.1 and later.

=head1 AUTHOR

Will Norris <wbniv@saneasylumstudios.com>.

=head1 SEE ALSO

L<WWW::Mechanize>.


