#
# Test script for testing TWiki refactorings, based on the concept
# that a refactoring should not change the rendered output from the
# various scripts.
#
# Note that THESE TESTS ARE AMAZINGLY CRUDE and should be backed up
# by unit tests in the refactored code. This is really just a sanity
# check, rather than a production quality test.
#
# Uses two installations, one using the old (golden) code, the other
# using the new test code.
#
# A subset of parameters is also tested; many are not, either because
# no-one can work out what they were for, or because nobody has been
# bothered yet. Contributors willing to write tests are always welcome!
#
# The basic strategy is to avoid dependencies on actual content wherever
# possible, and only use comparison between old and new to detect differences.
#
use strict;

package performanceTest;

require 'ScriptTestFixture.pm';

# base on the fixture so we get compare functionality
use base qw(ScriptTestFixture);

use vars qw($ab $slow $fast);

BEGIN {
##############################################################
# Test environment setup
# Note that for correct operation, the runner has to be able to delete
# files from the data areas belonging to the two test installations
$ab = "/usr/sbin/ab";
#############################################################
};

sub new {
  my $self = shift()->SUPER::new(@_);
  return $self;
}

# Use ApacheBench (ab) to ping the new server and return the mean number
# of requests per second.
sub abUrl {
  my ($this, $install, $func, $web, $topic, $opts,
	 $requests, $concurrent) = @_;
  if ($opts) {
    $opts =~ s/&/\\&/go;
    $opts = "?$opts";
  } else {
    $opts = "";
  }
  my $url = "$ScriptTestFixture::urlroot/$install/bin/$func/$web/$topic$opts";
  $opts = "";
  $opts .= " -n $requests" if ($requests);
  $opts .= " -c $concurrent" if ($concurrent);
  my $result = `$ab -q $opts $url`;
  $this->assert(!$?, "ab $url failed, $result");
  $result =~ m/Requests per second:\s*([\d\.]+)\s/;
  return $1;
}

my $web = "Sandbox";
my $actopic = "AutoCreatedTopic$$";

sub dotest_performance {
  my ($this,$install) = @_;

  my $repeats = 10;
  my $users = 3;
  my $i = 1;
  my $sum = 0;
  # Each topic in TWiki, which should include all plugin topics
  opendir(DIR, "$ScriptTestFixture::newdata/TWiki");
  foreach my $topic (grep { /\.txt$/ } readdir(DIR)) {
	$topic =~ s/\.txt//o;
	$sum += $this->abUrl($install, "view", $web, $topic, "", $repeats, $users);
	$i++;
	$| = 1;
	print "+";
	$| = 0;
  }
  closedir(DIR);
  my $view = $sum / $i;

  my $text = "Pugh,Pugh,Barney%20McGrew,Cuthbert,Dibble,Grubb";
  my $edit = $this->abUrl($install,
							 "edit", $web, $actopic,
							 "", $repeats, $users);
  my $save = $this->abUrl($install,
						  "save", $web, $actopic,
						  "text=$text&unlock=on&parent=Sausage",
						  $repeats, $users);

  # clean up fixture
  $this->deleteTopic($web, $actopic);

  print "| | *Requests per second* ||\n";
  print "| | *View* | *Edit* | *Save* |\n";
  print "| *$install* | $view | $edit | $save |\n";
}

sub test_slow {
  my $this = shift;
  $this->dotest_performance($ScriptTestFixture::old);
}

sub test_fast {
  my $this = shift;
  $this->dotest_performance($ScriptTestFixture::new);
}

1;
