# Plugin for TWiki Enterprise Collaboration Platform, http://TWiki.org/
#
# Copyright (C) 2019-2023 ALPS Aquaservice
# Copyright (C) 2019-2023 Peter Thoeny, peter09[at]thoeny.org
# and TWiki Contributors. All Rights Reserved.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version. For
# more details read LICENSE in the root of this distribution.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details, published at
# http://www.gnu.org/copyleft/gpl.html
#
# As per the GPL, removal of this notice is prohibited.

package TWiki::Plugins::ReplaceTextPlugin::CustomReplace;

use strict;

# =========================
# expected attributes:
#   * debug:   Debug flag
#
sub new {
    my $class = shift;
    my %attrs = @_;
    return bless( \%attrs, $class );
}

# =========================
# $this->replaceText( $web, $topic, $text, $search, $replace ) -> $text
#   * $web:      Name of web
#   * $topic:    Name of topic
#   * $text:     Text of topic
#   * $search:   Text to search for
#   * $replace:  Text to replace with
# return: $text: Text with replacement
#
sub replaceText {
    my ( $this, $web, $topic, $text, $search, $replace ) = @_;
    if($this->{debug}) {
        TWiki::Func::writeDebug("- replaceText($web, $topic, $search, $replace)");
    }
    if($replace =~ /\$[1-8]/) {
        # special case: $1, $2 etc are not expanded in $replace (nesting)
        $text =~ s/$search/_replacer($replace, $1, $2, $3, $4, $5, $6, $7, $8 )/ge;
    } else {
        $text =~ s/$search/$replace/g;
    }
    if($topic eq 'SomethingSpecial') {
        # $text =~ s/FIXME/FIXED/;
    }
    return $text;
}

#==========================
sub _replacer {
    my( $text, $p1, $p2, $p3, $p4, $p5, $p6, $p7, $p8 ) = @_;
    $text =~ s/\$1/$p1/g;
    $text =~ s/\$2/$p2/g;
    $text =~ s/\$3/$p3/g;
    $text =~ s/\$4/$p4/g;
    $text =~ s/\$5/$p5/g;
    $text =~ s/\$6/$p6/g;
    $text =~ s/\$7/$p7/g;
    $text =~ s/\$8/$p8/g;
    return $text;
}

1;
