# Plugin for TWiki Enterprise Collaboration Platform, http://TWiki.org/
#
# Copyright (C) 2019-2023 ALPS Aquaservice
# Copyright (C) 2019-2023 Peter Thoeny, peter09[at]thoeny.org 
# Copyright (C) 2019-2023 TWiki Contributors. All Rights Reserved.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version. For
# more details read LICENSE in the root of this distribution.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details, published at
# http://www.gnu.org/copyleft/gpl.html
#
# As per the GPL, removal of this notice is prohibited.

package TWiki::Plugins::ReplaceTextPlugin;

# =========================
our $VERSION = '$Rev: 31073 (2023-06-30) $';
our $RELEASE = '2023-06-26';
our $SHORTDESCRIPTION = 'Globally search and replace text in all topics of a web';
our $NO_PREFS_IN_TOPIC = 1;

# =========================
our $debug = $TWiki::cfg{Plugins}{ReplaceTextPlugin}{Debug} || 0;
our $web;
our $topic;
our $core;

# =========================
sub initPlugin {
    ( $topic, $web ) = @_;

    TWiki::Func::registerTagHandler( 'REPLACETEXT', \&_REPLACETEXT );

    # Plugin correctly initialized
    TWiki::Func::writeDebug( "- TWiki::Plugins::ReplaceTextPlugin::initPlugin( $web.$topic ) is OK" )
      if( $debug );

    return 1;
}

# =========================
sub _REPLACETEXT {
    my ( $session, $params, $theTopic, $theWeb, $meta ) = @_;

    # Lazy loading, e.g. compile core module only when required
    unless( $core ) {
        require TWiki::Plugins::ReplaceTextPlugin::Core;
        $core = new TWiki::Plugins::ReplaceTextPlugin::Core();
    }
    return $core->VarREPLACETEXT( $params, $theTopic, $theWeb, $meta );
}

# =========================
1;
