#
# Copyright (C) 2000-2001 Andrea Sterbini, a.sterbini@flashnet.it
# Copyright (C) 2001 Peter Thoeny, Peter@Thoeny.com
# Copyright (C) 2004 Rafael Alvarez, soronthar@yahoo.com
#
# Authors (in alphabetical order)
#   Andrea Bacchetta
#   Richard Bennett
#   Anthon Pang
#   Andrea Sterbini
#   Martin Watt
#   Rafael Alvarez
#   Thomas Eschner
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details, published at 
# http://www.gnu.org/copyleft/gpl.html
#
# =========================
#
# Manages the story and task coloring according to their completition status
#
# =========================
package TWiki::Plugins::Xp::Status;
use strict;

	# reasonable defaults for colouring. By default task and stories
    # have the same colour schemes.
    my %status= (
       unstarted => ['#FFCCCC' , 'Not Started'],
       inprogress => ['#FFFF99' , "In progress"],
	   finished => ['#99FF99' , "Finished"],	   
       acceptance => ['#CCFFFF' , "Acceptance"],
       complete => ['#99FF99' , "Complete"]
    );

sub getColor {
	my $status=shift;
	return $status{$status}[0];
}

sub getStatusS {
	my $status=shift;
	return $status{$status}[1];
}

sub getStatus {
	my ($storySpent,$storyEtc,$storyComplete) = @_;

	my $color="";
	my $storyStatS="";
	my $desc="";
	
	if ( $storySpent==0) {
		$desc="unstarted";

	}elsif ($storyEtc== 0)  { 
		if ($storyComplete eq "Y") { 
			$desc="complete";
		} else {
			$desc="acceptance";
		}
	} else { 
		$desc="inprogress";	
	}


	$color=$status{$desc}[0] || "";
	$storyStatS=$status{$desc}[1] ||"";
	
	return ($color,$storyStatS);
}

sub showColours {
    my ($web) = @_;

    my $table = "%TABLE{initsort=\"1\"}%\n";
    $table .= "|*name*|*colour*|*title*|\n";
    my ($key, $value);
    # read colours and put them in table
    
    while (($key, $value) = each(%status)) {
    	$table .= "|$key| <table width=\"100%\"><tr><td bgcolor=\"@$value[0]\">@$value[0]</td></tr></table>|@$value[1]|\n";
	}

    return $table	

}

#TODO code
    # now get defaults from XpTrackerPlugin topic
    #my $v;
    #foreach $option (keys %defaults) {
        # read defaults from XpTrackerPlugin topic
    #    $v = &TWiki::Func::getPreferencesValue("XPTRACKERPLUGIN_\U$option\E") || undef;
    #    $defaults{$option} = $v if defined($v);
    #}


1;
